<?php
namespace Mageants\AlsoBought\Controller\Index;

class Index extends \Magento\Framework\App\Action\Action
{

    /**
     * @var \Magento\Framework\Controller\Result\JsonFactory
     */
    protected $jsonFactory;
    /**
     * @var \Magento\Checkout\Model\Cart
     */
    protected $cart;
    /**
     * @var \Magento\Catalog\Model\ProductRepository
     */
    protected $_productRepository;

    /**
     * __construct
     * @param \Magento\Framework\App\Action\Context            $context
     * @param \Magento\Checkout\Model\Cart                     $cart
     * @param \Magento\Catalog\Model\ProductRepository         $productRepository
     * @param \Magento\Framework\Controller\Result\JsonFactory $jsonFactory
     * @param array                                            $data
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Checkout\Model\Cart $cart,
        \Magento\Catalog\Model\ProductRepository $productRepository,
        \Magento\Framework\Controller\Result\JsonFactory $jsonFactory,
        array $data = []
    ) {

        $this->_productRepository = $productRepository;
        $this->cart = $cart;
        $this->jsonFactory = $jsonFactory;
        return parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return $resultJson
     */
    public function execute()
    {

        $resultJson = $this->jsonFactory->create();
        $selectedId = $this->getRequest()->getPost('id_data');
        $parentProductId = $this->getRequest()->getPost('parent_product_id');
        $qty = 1;
        $flag = 0;

        try {

            $options = $selectedId;
                    $params = [
                        'product' => $parentProductId,
                        'super_attribute' => $options,
                        'qty' => $qty
                    ];

                    $loadParentProduct = $this->_productRepository->getById($parentProductId);

                    if ($this->cart->addProduct($loadParentProduct, $params)) {
                            
                        $flag = 1;
                        $this->cart->save();
                        $this->messageManager->addSuccess(__('Add to cart successfully.'));
                    }

        } catch (\Exception $e) {

            $this->messageManager->addException($e, $e->getMessage());
        }

        return $resultJson->setData([
            'success' => $flag
        ]);
    }
}
